/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.client.screen.SliderWidget;
import slimeknights.mantle.inventory.BaseContainerMenu;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.tables.client.inventory.module.GenericScreen;
import slimeknights.tconstruct.tables.client.inventory.widget.BorderWidget;

public class SideInventoryScreen<P extends MultiModuleScreen<?>, C extends AbstractContainerMenu>
extends ModuleScreen<P, C> {
    protected ScalableElementScreen overlap = GenericScreen.overlap;
    protected ElementScreen overlapTopLeft = GenericScreen.overlapTopLeft;
    protected ElementScreen overlapTopRight = GenericScreen.overlapTopRight;
    protected ElementScreen overlapBottomLeft = GenericScreen.overlapBottomLeft;
    protected ElementScreen overlapBottomRight = GenericScreen.overlapBottomRight;
    protected ElementScreen overlapTop = new ElementScreen(7, 0, 7, 7, 64, 64);
    protected ScalableElementScreen textBackground = GenericScreen.textBackground;
    protected ScalableElementScreen slot = GenericScreen.slot;
    protected ScalableElementScreen slotEmpty = GenericScreen.slotEmpty;
    protected ElementScreen sliderNormal = GenericScreen.sliderNormal;
    protected ElementScreen sliderLow = GenericScreen.sliderLow;
    protected ElementScreen sliderHigh = GenericScreen.sliderHigh;
    protected ElementScreen sliderTop = GenericScreen.sliderTop;
    protected ElementScreen sliderBottom = GenericScreen.sliderBottom;
    protected ScalableElementScreen sliderBackground = GenericScreen.sliderBackground;
    protected static final ResourceLocation GENERIC_INVENTORY = TConstruct.getResource("textures/gui/generic.png");
    protected BorderWidget border = new BorderWidget();
    protected int columns;
    protected int slotCount;
    protected int firstSlotId;
    protected int lastSlotId;
    protected int yOffset;
    protected int xOffset;
    protected boolean connected;
    protected SliderWidget slider = new SliderWidget(this.sliderNormal, this.sliderHigh, this.sliderLow, this.sliderTop, this.sliderBottom, this.sliderBackground);

    public SideInventoryScreen(P parent, C container, Inventory playerInventory, Component title, int slotCount, int columns) {
        this(parent, container, playerInventory, title, slotCount, columns, false, false);
    }

    public SideInventoryScreen(P parent, C container, Inventory playerInventory, Component title, int slotCount, int columns, boolean rightSide, boolean connected) {
        super(parent, container, playerInventory, title, rightSide, false);
        this.connected = connected;
        this.columns = columns;
        this.slotCount = slotCount;
        this.f_97726_ = columns * this.slot.w + this.border.w * 2;
        this.f_97727_ = this.calcCappedYSize(this.slot.h * 10);
        if (connected) {
            if (this.right) {
                this.border.cornerTopLeft = this.overlapTopLeft;
                this.border.borderLeft = this.overlap;
                this.border.cornerBottomLeft = this.overlapBottomLeft;
            } else {
                this.border.cornerTopRight = this.overlapTopRight;
                this.border.borderRight = this.overlap;
                this.border.cornerBottomRight = this.overlapBottomRight;
            }
        }
        this.yOffset = 0;
        this.updateSlots();
    }

    protected boolean shouldDrawName() {
        return this.f_97732_ instanceof BaseContainerMenu;
    }

    public boolean shouldDrawSlot(Slot slot) {
        if (slot.getSlotIndex() >= this.slotCount) {
            return false;
        }
        if (!this.slider.isEnabled()) {
            return true;
        }
        return this.firstSlotId <= slot.getSlotIndex() && this.lastSlotId > slot.getSlotIndex();
    }

    public boolean m_97774_(Slot slotIn, double mouseX, double mouseY) {
        return super.m_97774_(slotIn, mouseX, mouseY) && this.shouldDrawSlot(slotIn);
    }

    public void updateSlotCount(int newSlotCount) {
        if (this.slotCount == newSlotCount) {
            return;
        }
        this.slotCount = newSlotCount;
        this.updatePosition(this.parent.cornerX, this.parent.cornerY, this.parent.realWidth, this.parent.realHeight);
        this.updatePosition(this.parent.cornerX, this.parent.cornerY, this.parent.realWidth, this.parent.realHeight);
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        this.f_97727_ = this.calcCappedYSize(parentSizeY - 10);
        if (this.getDisplayedRows() < this.getTotalRows()) {
            this.slider.enable();
            this.f_97726_ = this.columns * this.slot.w + this.slider.width + 2 * this.border.w;
        } else {
            this.slider.disable();
            this.f_97726_ = this.columns * this.slot.w + this.border.w * 2;
        }
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        if (this.connected) {
            if (this.yOffset == 0) {
                if (this.right) {
                    this.border.cornerTopLeft = this.overlapTop;
                } else {
                    this.border.cornerTopRight = this.overlapTop;
                }
            }
            this.xOffset = (this.border.w - 1) * (this.right ? -1 : 1);
            this.f_97735_ += this.xOffset;
        } else {
            this.xOffset = 0;
        }
        this.f_97736_ += this.yOffset;
        this.border.setPosition(this.f_97735_, this.f_97736_);
        this.border.setSize(this.f_97726_, this.f_97727_);
        int y = this.f_97736_ + this.border.h;
        int h = this.f_97727_ - this.border.h * 2;
        if (this.shouldDrawName()) {
            y += this.textBackground.h;
            h -= this.textBackground.h;
        }
        this.slider.setPosition(this.f_97735_ + this.columns * this.slot.w + this.border.w, y);
        this.slider.setSize(h);
        this.slider.setSliderParameters(0, this.getTotalRows() - this.getDisplayedRows(), 1);
        this.updateSlots();
    }

    private int getDisplayedRows() {
        return this.slider.height / this.slot.h;
    }

    private int getTotalRows() {
        int total = this.slotCount / this.columns;
        if (this.slotCount % this.columns != 0) {
            ++total;
        }
        return total;
    }

    private int calcCappedYSize(int max) {
        int h = this.slot.h * this.getTotalRows();
        h = this.border.getHeightWithBorder(h);
        if (this.shouldDrawName()) {
            h += this.textBackground.h;
        }
        while (h > max) {
            h -= this.slot.h;
        }
        return h;
    }

    protected void updateSlots() {
        this.firstSlotId = this.slider.getValue() * this.columns;
        this.lastSlotId = Math.min(this.slotCount, this.firstSlotId + this.getDisplayedRows() * this.columns);
        int xd = this.border.w + this.xOffset;
        int yd = this.border.h + this.yOffset;
        if (this.shouldDrawName()) {
            yd += this.textBackground.h;
        }
        for (Slot slot : this.f_97732_.f_38839_) {
            if (this.shouldDrawSlot(slot)) {
                int offset = slot.getSlotIndex() - this.firstSlotId;
                int x = offset % this.columns * this.slot.w;
                int y = offset / this.columns * this.slot.h;
                slot.f_40220_ = xd + x + 1;
                slot.f_40221_ = yd + y + 1;
                if (this.right) {
                    slot.f_40220_ += this.parent.realWidth;
                    continue;
                }
                slot.f_40220_ -= this.f_97726_;
                continue;
            }
            slot.f_40220_ = 0;
            slot.f_40221_ = 0;
        }
    }

    public void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        if (this.shouldDrawName()) {
            this.f_96547_.m_92883_(matrices, this.m_96636_().getString(), (float)this.border.w, (float)(this.border.h - 1), 0x404040);
        }
    }

    protected void m_7286_(PoseStack matrices, float partialTicks, int mouseX, int mouseY) {
        this.f_97735_ += this.border.w;
        this.f_97736_ += this.border.h;
        int x = this.f_97735_;
        int y = this.f_97736_;
        int midW = this.f_97726_ - this.border.w * 2;
        RenderUtils.setup(GENERIC_INVENTORY);
        this.border.draw(matrices);
        if (this.shouldDrawName()) {
            this.textBackground.drawScaledX(matrices, x, y, midW);
            y += this.textBackground.h;
        }
        this.drawSlots(matrices, x, y);
        if (this.slider.isEnabled()) {
            this.slider.update(mouseX, mouseY);
            this.slider.draw(matrices);
            this.updateSlots();
        }
        this.f_97735_ -= this.border.w;
        this.f_97736_ -= this.border.h;
    }

    protected int drawSlots(PoseStack matrices, int xPos, int yPos) {
        int y;
        int width = this.columns * this.slot.w;
        int height = this.f_97727_ - this.border.h * 2;
        int fullRows = (this.lastSlotId - this.firstSlotId) / this.columns;
        for (y = 0; y < fullRows * this.slot.h && y < height; y += this.slot.h) {
            this.slot.drawScaledX(matrices, xPos, yPos + y, width);
        }
        int slotsLeft = (this.lastSlotId - this.firstSlotId) % this.columns;
        if (slotsLeft > 0) {
            this.slot.drawScaledX(matrices, xPos, yPos + y, slotsLeft * this.slot.w);
            this.slotEmpty.drawScaledX(matrices, xPos + slotsLeft * this.slot.w, yPos + y, width - slotsLeft * this.slot.w);
        }
        return width;
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.slider.isEnabled()) {
            this.slider.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
        }
        return super.handleMouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (this.slider.isEnabled()) {
            this.slider.handleMouseReleased();
        }
        return super.handleMouseReleased(mouseX, mouseY, state);
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollData) {
        if (!this.slider.isEnabled()) {
            return super.handleMouseScrolled(mouseX, mouseY, scrollData);
        }
        return this.slider.mouseScrolled(scrollData, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule((int)mouseX, (int)mouseY));
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

